--[[

NoteCase Pro script
	See http://www.notecasepro.com/

SCRIPT NAME: TitleFormattingTest.lua

	v. 1.0 

PURPOSE: The script illustrates usage of the following scriptable commands:

	Nc_Note_Title_Bold_Set
	Nc_Note_Title_Italic_Set
	Nc_Note_Title_Font_Set
	Nc_Note_Title_Text_Color_Set
	Nc_Note_Title_Bkg_Color_Set
	
NOTE: The Nc_Note_Title_Font_Set command will overwrite attributes set with the Nc_Note_Title_Bold_Set and Nc_Note_Title_Italic_Set commands. See report created by this script. 


RIGHTS: This script's author, Miroslav Rajcic, hereby waives all copyright and related or neighboring rights to this script, pursuant to the Creative Commons CC0 Universal relinquishment of rights found at http://creativecommons.org/publicdomain/zero/1.0/

--]]

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 4 or (nMaj == 4 and nMin < 4) or (nMaj == 4 and nMin == 4 and nRev < 8)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 4.4.8")
	return
end

--get IDs of current document and note
local nDocID = Nc_Doc_ID_GetCur()
local strNoteID = Nc_Note_ID_GetCur(nDocID)

-- check to see if note is selected and abort the script if not
if strNoteID == "" then
  Nc_GUI_InfoBox("ERROR: A note must be selected before executing this action. Execution was terminated.", 1, "ERROR")
  return
end 

Nc_Note_Title_Bold_Set(nDocID, strNoteID, 1)
Nc_Note_Title_Italic_Set(nDocID, strNoteID, 1)
-- Font will overwrite italic, bold stays because it is part of the font
Nc_Note_Title_Font_Set(nDocID, strNoteID, "Tahoma Bold 18")
Nc_Note_Title_Text_Color_Set(nDocID, strNoteID, "rgb(255,12,56)")
Nc_Note_Title_Bkg_Color_Set(nDocID, strNoteID, "rgb(5,12,156)")

is_bold = Nc_Note_Title_IsFormatted(nDocID, strNoteID, 1)
is_italic = Nc_Note_Title_IsFormatted(nDocID, strNoteID, 3)
is_font, font = Nc_Note_Title_IsFormatted(nDocID, strNoteID, 17)
is_color, color = Nc_Note_Title_IsFormatted(nDocID, strNoteID, 7)
is_bkgcolor, bkgcolor = Nc_Note_Title_IsFormatted(nDocID, strNoteID, 15)
Nc_GUI_MessageBox("Bold=" .. is_bold .. "\nItalic=" .. is_italic .. "\nFont=" .. is_font .. "," .. font .. "\nColor=" .. is_color .. "," .. color .. "\nBackground=" .. is_bkgcolor .. "," .. bkgcolor)