--[[

NoteCase Pro script
	See http://www.notecasepro.com/

SCRIPT NAME: MultiInput.lua

	v. 1.0 

PURPOSE: The script demonstrates the usage of Nc_GUI_MultiInputDlg API.

RIGHTS: This script's author, Miroslav Rajcic, hereby waives all copyright and related or neighboring rights to this script, pursuant to the Creative Commons CC0 Universal relinquishment of rights found at http://creativecommons.org/publicdomain/zero/1.0/

--]]

-- make sure app version supports necessary scriptable program commands
local nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 4 or (nMaj == 4 and nMin < 4) or (nMaj == 4 and nMin == 4 and nRev < 6)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 4.4.6")
	return
end

-- gets ID for current document
local nDocID = Nc_Doc_ID_GetCur()

-- prepare table version to fill the dialog
items = {}

item1 = {}
item1["type"] = "text"
item1["title"] = "Enter text"
item1["value"] = "Value1"
items[#items + 1] = item1

item2 = {}
item2["type"] = "checkbox"
item2["title"] = "Check box:"
item2["value"] = "aaa" -- non-empty to check initially
items[#items + 1] = item2

item3 = {}
item3["type"] = "password"
item3["title"] = "Enter password"
item3["value"] = "Password"
items[#items + 1] = item3

ok, results = Nc_GUI_MultiInputDlg("Title", items, "Demonstrates input of\nmultiple values of possibly different types", 600, 400)

message="OK pressed:" .. ok .. "\nResults:\n"
for i=1, #results do
  message = message .. results[i] .. "\n"
end
Nc_GUI_MessageBox(message)