-- Notecase Pro sample script (requires Notecase Pro >= 3.1.4)
--
-- Description:
-- import custom tabbed text format with note text lines prepended with ;;
-- Note the commented calls to Nc_GUI_MessageBox that were used to debug the script
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 1) or (nMaj == 3 and nMin == 1 and nRev < 4)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.1.4")
	return
end

-- break string into the array
function lines(str)
  local t = {}
  local i, lstr = 1, #str
  while i <= lstr do
    local x, y = string.find(str, "\r?\n", i)
    if x then t[#t + 1] = string.sub(str, i, x - 1)
    else break
    end
    i = y + 1
  end
  if i <= lstr then t[#t + 1] = string.sub(str, i) end
  return t
end

-- get info on the currently active document/note
nDocID = Nc_Doc_ID_GetCur()
strCurNoteID = Nc_Note_ID_GetCur(nDocID)

-- get file name to import
filename = Nc_GUI_FileDlg(0) 
if filename == "" then
	return 
end

-- read file content
f = io.open(filename, "r")
local strFileData = f:read("*all")
f:close()

-- Nc_GUI_MessageBox("File contents:\n\n" .. strFileData)

nCurNoteTabLevel = -1
strCurrentNoteID = ""

-- break text lines into the list
local tLines = lines(strFileData)

-- for each tabbed text file line
nLines = #tLines
-- Nc_GUI_MessageBox(nLines.." lines found in the input file")

for i=1,nLines do
	local strLine = tLines[i]

	-- calculate indentation level
	local nCurTabLevel = 0
	local nLineLen = string.len(strLine)
	for j=1,nLineLen do
			local strChar = string.sub(strLine, j, j)
			if strChar == '\t' then
				nCurTabLevel = nCurTabLevel + 1
			else
					break
			end
	end

	-- check if the text is a title or a text line (prefixed with ;;)
	local nIsTitle = 1
	if nCurTabLevel + 2 <= nLineLen then
		local strPfx = string.sub(strLine, nCurTabLevel+1, nCurTabLevel+2);
		if strPfx == ";;" then
				nIsTitle = 0
			end
	end

	-- Nc_GUI_MessageBox("Line #".. i ..", is_title="..nIsTitle ..", level="..nCurTabLevel..": "..strLine)

	-- now do the insertions
	if nIsTitle > 0 then
		-- insert line as new note (text line is a title encoded with ANSI code page)
		local strTitle = string.sub(strLine, nCurTabLevel+1)
		strTitle = Nc_String_AnsiToUtf8(strTitle) 
		
		-- calculate parent note based on the level info
		strParentNoteID = strCurrentNoteID
		nParentNoteLevel = nCurNoteTabLevel
		while nParentNoteLevel >= nCurTabLevel do
			strParentNoteID = Nc_Note_Parent_GetID(nDocID, strParentNoteID)
			nParentNoteLevel = nParentNoteLevel - 1
		end

		strCurrentNoteID = Nc_Note_Insert(nDocID, strParentNoteID, -1, strTitle) 

		-- remember current tab level
    nCurNoteTabLevel = nCurTabLevel
	else
		-- insert possible text contents line (encoded with ANSI code page)
		-- append as note text only if it has the same tab level as previous note line
		if nCurTabLevel == nCurNoteTabLevel then
			local strAddText = string.sub(strLine, nCurTabLevel+3)
			strAddText = Nc_String_AnsiToUtf8(strAddText) 

			local strNoteText = Nc_Note_Content_Get(nDocID, strCurrentNoteID, 0)
			if string.len(strNoteText) > 0 then
				strNoteText = strNoteText .. "\n"
			end
			strNoteText = strNoteText .. strAddText
			
			Nc_Note_Content_Set(nDocID, strCurrentNoteID, strNoteText)
    end

	end
	
end