--[[

NoteCase Pro script
    See http://www.notecasepro.com/

SCRIPT NAME: 48_ChangeAllFonts.lua

   v. 1.0

PURPOSE: This script changes all font settings (in all notes of the current document) to the font assigned to variable strFont in this script, which if an empty string will simply remove all explicit font assignments. No pre-existing font assignments will remain after running this script.
Exceptions: Any read-only notes in the document are bypassed and no changes will be made in them. Also, the script affects font assignments in the Note Pane only. Any font assignments for note titles are not changed.
Notice that you can use two copies of this script (after renaming their files), one set to remove all font assignments and one set to add a font assignment to each note.

USAGE INSTRUCTIONS:  Make the document whose notes you wish to process the current document then execute this script (after configuring it as desired).

CONFIGURATION: To simply remove all explicit font assignments, set the value of strFont in the first code line of this script to an empty string (two quotation marks only). For example:

    local strFont = ""

To set all notes to a font, activate the Fonts dialog from the Format Menu and look up the font you wish to use to get the precise spelling (setting is case sensitive). Then set the first line of code in this script to assign that font name and a size, separated by a single space. For example:

   local strFont = "Tahoma 12"

RIGHTS: This script's author, Paul E. Merrell, hereby waives all copyright and related or neighboring rights to this script, pursuant to the Creative Commons CC0 Universal relinquishment of rights found at http://creativecommons.org/publicdomain/zero/1.0/

--]]

-- edit the following code line per the instructions in the CONFIGURATION section above
local strFont = "Tahoma 12"

-- get current document's ID
nDocID = Nc_Doc_ID_GetCur()

local strMessage = [[
This script removes all font assignments
from all notes of the document. If
variable strFont is set to a font and
size, new font assignments will be made.
If strFont is an empty string, no new
assignments will be made and all existing
assignments will be removed.

Do you want to proceed?
]]

-- display warning and abort script if user selects "no"
nCancel = Nc_GUI_MessageBox(strMessage, 1, 0, "WARNING")
if nCancel == 3 then 
	return
end

-- get doc info
local nDocID = Nc_Doc_ID_GetCur()
local nReadOnly = Nc_Doc_ReadOnly_Get(nDocID)

-- abort script if doc is read-only
if nReadOnly == 1 then
	Nc_GUI_InfoBox("ERROR: Document is read-only;  no changes possible.", 1, "ERROR")
	return
end -- if nReadOnly

-- get document's note count
local nTotalNotes = Nc_Doc_NoteCount(nDocID)

-- for each note
for i=1,nTotalNotes do

    -- get note ID
    local strNoteID = Nc_Note_ID_GetByIdx(nDocID, i-1)

   -- do the action if the note is not read-only
   if Nc_Note_Flag_ReadOnly_Get(nDocID, strNoteID) ~= 1 then
      Nc_Note_Format_Font_Apply(nDocID, strNoteID, strFont)
   end -- if

end -- for each
