-- Notecase Pro sample script (requires Notecase Pro >= 3.5.0)
--
-- Description:
-- Demonstrates RSA encryption using Notecase APIs
-- Key files were generated with:
-- 1. private key: openssl genrsa -out private_key.pem 1024
-- 2. public key from private key: openssl rsa -pubout -outform PEM -in private_key.pem -out public_key.pem
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 5)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.5.0")
	return
end 

-- define private and public keys
strPublicKey = [[
-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCbrADej8BxPdDASIF54YycAmw1
9mAbJ/hmjMMj6EXshma1cmBIM/HDZuQejahniCHBbK1kV8XUSk/4JcmrZDeOX6ea
TuFdtlv6M/qWSFpZ/hVwzQ06u9u0LGcByyQMrcznVtfdsIaW2FunScmj2DNjzF8S
BiW9rHw/307VPI7iKQIDAQAB
-----END PUBLIC KEY-----
]]

strPrivateKey = [[
-----BEGIN RSA PRIVATE KEY-----
MIICXAIBAAKBgQCbrADej8BxPdDASIF54YycAmw19mAbJ/hmjMMj6EXshma1cmBI
M/HDZuQejahniCHBbK1kV8XUSk/4JcmrZDeOX6eaTuFdtlv6M/qWSFpZ/hVwzQ06
u9u0LGcByyQMrcznVtfdsIaW2FunScmj2DNjzF8SBiW9rHw/307VPI7iKQIDAQAB
AoGAF1Ninfa0Q0Ob7/PtUrH1O7sxM7TDGc6XbeZRpyO6toI9CZslyiveYgUc0Wcw
gLLpO+5o3Mw6HGE2MlyXJ1NQ74yZ97UnO+qhtXKcbur9MfMsbAt0W8OwHOej7lsw
V+UeDv//AGBG8OLwPSkDuOViqtcyK3TAkPc0uGu8LlM+SMECQQDJE4Rn7zbqyBTw
gs3G8G3G3f4htjlm4TmrNY8OSXJy8BwGxWIcpQApPcY1t76skAUli5YjWyhOvM0P
kINuIw/1AkEAxjGJJq/Nsay2HzwY0Fk2w52o5YQSvrfvMnE2snXKXilUl43VK588
9PP1ESCMZuD91YQPXJYWXN6jFHI/d/Ws5QJAfJ/fIbfu9qdZ6xN3TMT5lRdECkrx
2uTfJFFGwBkfmUNea4fs3koaBnWmIucmg7ejqPiR7onyOpLkGbB89Uc//QJAMZ3/
Hv9OOJfrdEBgWfCrxCc5PFRnOPXlXTR4pA7XHeGs+tAYOPaBlTVp+eKzI6JaCdUo
3133tUJLg3fiqc6IfQJBAI7d62e/b+x26NjAST/tUzPCyUfv/REtgFH7OFjQtF3m
a8R/b+KG8Lam3ciP3/nT9ZhbEz7ixwZtOyJV+CVQeGI=
-----END RSA PRIVATE KEY-----
]]

-- original data to be encrypted
strData = "Two bee oar knot 2B"

strEncryptedData = Nc_Util_RSA_Sign(strData, strPrivateKey)

-- show data length after signing (binary string can not be displayed as text)
Nc_GUI_InfoBox("Signed data length: " .. string.len(strEncryptedData))

strDecryptedData = Nc_Util_RSA_Verify(strEncryptedData, strPublicKey)

-- show data length after verifying (should be equal to the original text)
Nc_GUI_InfoBox("Verified data: " .. strDecryptedData)
