-- Notecase Pro sample script (requires Notecase Pro >= 3.3.1)
--
-- Description:
-- import a folder filled with RTF files (create a new note for each file)
-- Script was made by tweaking the script #22
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 5) or (nMaj == 3 and nMin == 5 and nRev < 1)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.5.1")
	return
end

-- create new document
nDocID = Nc_Doc_New()

-- start enumerating files and folders
-- strTopLevel = "C:\\temp\\rtf\\"	-- use "/home/user/test/" for Linux
strTopLevel = Nc_GUI_FileDlg(0, "", "Pick Top Directory", "", 0, 1)

function MatchExtension(strName)
  if string.find(strName,"%.rtf$") or string.find(strName,"%.RTF$") then 
    return true
  end
  return false
end 

function CountFiles(strCurrentDir)
 local nCount = 0
 for file in lfs.dir(strCurrentDir) do
    if file ~= "." and file ~= ".." then
    local strEntry = strCurrentDir..'/'..file
    local attr = lfs.attributes (strEntry)
    assert (type(attr) == "table")
    if attr.mode == "directory" then
      -- uncomment the line below to import the subdirectories too (recursively)
      -- nCount = nCount + CountFiles(strEntry)
    else
      if MatchExtension(strEntry) then
        nCount = nCount + 1
      end
    end
    end
 end
 return nCount  
end 

function ProcessDir(strCurrentDir)

  for file in lfs.dir(strCurrentDir) do
    if file ~= "." and file ~= ".." then
       local strEntry = strCurrentDir..'/'..file
        local attr = lfs.attributes (strEntry)
        assert (type(attr) == "table")
        if attr.mode == "directory" then
            -- uncomment the line below to import the subdirectories too (recursively)
            -- ProcessDir (strEntry)
        else
            -- create note for given file entry
            -- process only RTF files 
            if MatchExtension(strEntry) then 
              -- increment progress position
              nCurFile = nCurFile + 1
              Nc_GUI_ProgressDlg_SetPos(nCurFile) 
            
              nCnt = Nc_Doc_NoteCount(nDocID)
            
              Nc_Doc_Import(nDocID, strEntry, -1, 0)	-- 0 -> hide internal progress, using our own
            
              -- assign a name to the new note (filename minus the ".rtf")
              strNoteID = Nc_Note_ID_GetByIdx(nDocID, nCnt)
              strTitle = file
              strTitle = string.sub(strTitle, 0, -5)
              Nc_Note_Title_Set(nDocID, strNoteID, strTitle)
            end
        end
    end
  end

end -- function

-- show import progress
nCurFile = 0
nTotalFiles = CountFiles(strTopLevel)
-- Nc_GUI_MessageBox("Total files:" .. nTotalFiles)
Nc_GUI_ProgressDlg_Start("Importing files", nTotalFiles) 

ProcessDir(strTopLevel)

Nc_Note_ID_SetCur("")
Nc_GUI_ProgressDlg_Close()
Nc_GUI_MessageBox("Done!")