-- Notecase Pro sample script (requires Notecase Pro >= 3.1.3)
-- 
-- Description
-- Assigns an icon to the newly created note based on the icon of its parent 
-- (6 predefined internal icons are cycled)
-- Register this script to be executed on "Post note insert" event to get the automatic icon assignment
--  See Help file > How To > Scripts, Usage of > Launch Scripts Quicker > Launch Scripts Automatically.
-- Automatic icon assignment must be disabled for this script to function as desired. 
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/ 

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 1) or (nMaj == 3 and nMin == 1 and nRev < 3)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.1.3")
	return
end

-- You can customize the icons to be assigned by substuting icon names within the quotation marks in this section.
-- Use the same icon names that are displayed in the program's Pick Icon dialog. 
-- define 6 internal icons to use in the following order.
strIcon1 = "flag_blue"
strIcon2 = "flag_green"
strIcon3 = "flag_orange"
strIcon4 = "flag_pink"
strIcon5 = "flag_purple"
strIcon6 = "flag_red"

-- get current note and its parent note
nDocID = Nc_Doc_ID_GetCur()
strCurNoteID = Nc_Note_ID_GetCur(nDocID)
if strCurNoteID == "" then
 	Nc_GUI_MessageBox("No note selected, aborting")
	return 
end 
strParentNoteID = Nc_Note_Parent_GetID(nDocID, strCurNoteID)

-- Nc_GUI_MessageBox("Parent ID" .. strParentNoteID)

-- get parent note icon if parent exists
if strParentNoteID == "" then
	nIconType = -1
	strIconValue = ""
else
	nIconType, strIconValue = Nc_Note_Icon_GetValues(nDocID, strParentNoteID)
end

-- Nc_GUI_MessageBox("Parent icon (type " .. nIconType .. ") " .. strIconValue)

-- now select "next" icon in a set based on the value of parent's icon
if strIconValue == strIcon1 then
	strNewIcon = strIcon2
else if strIconValue == strIcon2 then
		strNewIcon = strIcon3
else if strIconValue == strIcon3 then
	strNewIcon = strIcon4
else if strIconValue == strIcon4 then
	strNewIcon = strIcon5
else if strIconValue == strIcon5 then
	strNewIcon = strIcon6
else
	strNewIcon = strIcon1
end
end
end
end
end

-- Nc_GUI_MessageBox("Selected icon " .. strNewIcon)

-- set icon for the current note to the "next" icon in the set
Nc_Note_Icon_SetValues(nDocID, strCurNoteID, 1, strNewIcon) 