-- Notecase Pro sample script (requires Notecase Pro >= 3.1.3)
--
-- Description:
-- sets the icons for all the notes in the current document 
-- (if the note has children it gets "folder" icon, if not it gets "blank" icon)
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 1) or (nMaj == 3 and nMin == 1 and nRev < 3)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.1.3")
	return
end

-- get info on the currently active document
nDocID = Nc_Doc_ID_GetCur()
nNoteCount = Nc_Doc_NoteCount(nDocID)

-- for each document note
for i=1,nNoteCount do 
	-- get info on the note (note indexes start from 0)
	strNoteID    = Nc_Note_ID_GetByIdx(nDocID, i-1)

	nChildren = Nc_Note_ChildCount(nDocID, strNoteID)
	
	-- set an icon to the note depending if it has children or not
	if nChildren > 0 then
		Nc_Note_Icon_SetValues(nDocID, strNoteID, 1, "folder")
	else
		Nc_Note_Icon_SetValues(nDocID, strNoteID, 1, "blank")
	end
end 
