-- Notecase Pro sample script (requires Notecase Pro >= 3.1.4)
--
-- Description:
-- enclose selected text with the block marker text ("---") 
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 1) or (nMaj == 3 and nMin == 1 and nRev < 4)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.1.4")
	return
end

-- get info on the currently active document/note
nDocID = Nc_Doc_ID_GetCur()
strCurNoteID = Nc_Note_ID_GetCur(nDocID)

nFrom, nTo = Nc_Note_SelectionRange_Get(nDocID, strCurNoteID)

-- insert block marker at both ends of the selection
strBlock = "\n-----------------------------\n\n"
Nc_Note_Content_Set(nDocID, strCurNoteID, strBlock, 0, nTo, nTo)
Nc_Note_Content_Set(nDocID, strCurNoteID, strBlock, 0, nFrom, nFrom)
