-- Notecase Pro sample script (requires Notecase Pro >= 3.1.3)
--
-- Description:
-- Fetches ID for current note and writes it to the clipboard in the form of hyperlink to this note
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 1) or (nMaj == 3 and nMin == 1 and nRev < 3)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.1.3")
	return
end

-- get info on the currently active document/note
nDocID = Nc_Doc_ID_GetCur()
strCurNoteID = Nc_Note_ID_GetCur(nDocID)
if strCurNoteID == "" then
	Nc_GUI_MessageBox("No note selected, aborting")
else
	strNoteTitle = Nc_Note_Title_Get(nDocID, strCurNoteID)
	
	-- if note title has multiple lines, replace new line
	-- with space to make the title fit into a single line
	strNoteTitle = string.gsub(strNoteTitle, "\n", " ") 

	-- comment next two code lines if you want multiple spaces between words in the title
	
	-- if they exist replace triple spaces in title with single space 
	strNoteTitle = string.gsub(strNoteTitle, "   ", " ")

	-- if they exist replace double spaces in note title with single space
	strNoteTitle = string.gsub(strNoteTitle, "  ", " ")
	
	-- write link to clipboard
	Nc_Env_Clipboard_Set("<a href=\"#" .. strCurNoteID .. "\">" .. strNoteTitle .. "</a>", 1)
end 