-- Notecase Pro sample script (requires Notecase Pro >= 3.1.3)
--
-- Description:
-- gets the selected text in the currently selected note, sorts it by text lines and replaces the selection back
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 1) or (nMaj == 3 and nMin == 1 and nRev < 3)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.1.3")
	return
end

-- break string into the array
function lines(str)
  local t = {}
  local i, lstr = 1, #str
  while i <= lstr do
    local x, y = string.find(str, "\r?\n", i)
    if x then t[#t + 1] = string.sub(str, i, x - 1)
    else break
    end
    i = y + 1
  end
  if i <= lstr then t[#t + 1] = string.sub(str, i) end
  return t
end

-- get info on the currently active document/note
nDocID = Nc_Doc_ID_GetCur()
strCurNoteID = Nc_Note_ID_GetCur(nDocID)

if strCurNoteID == "" then
 	Nc_GUI_MessageBox("No note selected, aborting")
	return 
end  

nFrom, nTo = Nc_Note_SelectionRange_Get(nDocID, strCurNoteID)
strText = Nc_Note_Content_Get(nDocID, strCurNoteID, 0, nFrom, nTo)

-- sort the text
local eol = string.match(strText, "\n$")
local buf = lines(strText)
table.sort(buf, function (a, b)
return string.lower(a) < string.lower(b)
end)
local out = table.concat(buf, "\n")
if eol then out = out.."\n" end

-- write text back

Nc_Note_Content_Set(nDocID, strCurNoteID, out, 0, nFrom, nTo)