--[[

NoteCase Pro script
	See http://www.notecasepro.com/

SCRIPT NAME: ToggleGui.lua

	v. 1.0 

PURPOSE: The script will switch Gui between minimal (most of the widgets hidden) and maximal (most of the widgets visible) mode, based on visibility of Note Title Bar widget.
To call the script in minimal mode, press Alt key to make the Menu Bar visible, so you can access the menu item needed to call the script. 

RIGHTS: This script's author, Miroslav Rajcic, hereby waives all copyright and related or neighboring rights to this script, pursuant to the Creative Commons CC0 Universal relinquishment of rights found at http://creativecommons.org/publicdomain/zero/1.0/

--]]

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 4 or (nMaj == 4 and nMin < 5) or (nMaj == 4 and nMin == 5 and nRev < 1)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 4.5.1")
	return
end

-- toggle visibility
showGui = 1
if Nc_GUI_NoteTitleBar_IsVisible() > 0 then
  showGui = 0
end
hideGui = (showGui+1)%2

Nc_GUI_StatusBar_Show(showGui)
Nc_GUI_MenuBar_Show(showGui)
Nc_GUI_DocumentTabs_Show(showGui)
Nc_GUI_SearchBar_Show(showGui)
Nc_GUI_Toolbar_Main_Show(showGui)
Nc_GUI_LineNumbers_Show(showGui)
Nc_GUI_NoteTitleBar_Show(showGui)
Nc_GUI_TagsPane_Show(showGui)
Nc_GUI_AttachmentsPane_Show(showGui)
Nc_GUI_ColumnHeaders_Show(showGui)
Nc_GUI_MainWindowTitle_ShowDocPath(hideGui)

-- Nc_GUI_MessageBox("Visibility after show GUI: " .. showGui .. "\nNote title bar: " .. Nc_GUI_NoteTitleBar_IsVisible() .. "\nTags pane: " .. Nc_GUI_TagsPane_IsVisible() .. "\nMenu bar: " .. Nc_GUI_MenuBar_IsVisible() .. "\nattachments pane: " .. Nc_GUI_AttachmentsPane_IsVisible() .. "\ndocument tabs: " .. Nc_GUI_DocumentTabs_IsVisible() .. "\nstatus bar: " .. Nc_GUI_StatusBar_IsVisible() .. "\nColumn headers: " .. Nc_GUI_ColumnHeaders_IsVisible())