--[[

NoteCase Pro sample script (requires Notecase Pro >= 4.1.2)

   See http://www.notecasepro.com/

SCRIPT NAME: Sync List Remote

   Version 1.0 

PURPOSE: Script displays a message box with the list of Notecase documents available on the sync server configured to be used in NoteCase Pro. 

RIGHTS: This script's author, Miroslav Rajcic, hereby waives all copyright and related or neighboring rights to this script, pursuant to the Creative Commons CC0 Universal relinquishment of rights found at http://creativecommons.org/publicdomain/zero/1.0/

--]]

bOk, strErr, tRes = Nc_Sync_RemoteList()

if 1 == bOk then
	strMsg = "Remote list count=" .. #tRes .. "\n"
	for i=1,#tRes do
		strMsg = strMsg .. "ID=" .. tRes[i]['id'] .. ",\t"
		strMsg = strMsg .. "Size=" .. tRes[i]['size'] .. ",\t"
	  strMsg = strMsg .. "Name='" .. tRes[i]['name'] .. "'\n"
	end
	Nc_GUI_MessageBox(strMsg)
else
	Nc_GUI_MessageBox("Connection failed")
end
