--[[

NoteCase Pro script

   See http://www.notecasepro.com/


SCRIPT NAME: 53_CollapseAllOtherNotes.lua

   v. 1.0 

PURPOSE: The Collapse All Other Notes script, when assigned to the After Note Focused event trigger, automatically collapses all notes in the document other than the current note, which keeps your Tree Pane compact and clear of clutter.   

CONFIGURATION: Assign this script to the After Note Focused event trigger. See for instructions, Help file > Automation, Scripts and Plugins > Launch Scripts and Plugin Actions Quicker.

RIGHTS: This script's author, Miroslav Rajcic, hereby waives all copyright and related or neighboring rights to this script, pursuant to the Creative Commons CC0 Universal relinquishment of rights found at http://creativecommons.org/publicdomain/zero/1.0/

--]]

-- get info on the currently active document/note
local nDocID = Nc_Doc_ID_GetCur()
local strCurNoteID = Nc_Note_ID_GetCur(nDocID)

-- function to collapse notes recursively (leaving the current note visible)
function CollapseRecursively(strNoteID)
    local nCount = Nc_Note_ChildCount(nDocID, strNoteID)
    for i=0, nCount-1 do
        local strChildID = Nc_Note_Child_GetID(nDocID, strNoteID, i)
        if Nc_Note_IsAncestor(nDocID, strChildID, strCurNoteID) > 0 then
            CollapseRecursively(strChildID)
        else
            Nc_Tree_Note_Collapse(nDocID, strChildID)
        end
    end
end

-- execute function
CollapseRecursively("")

-- uncomment next line if you want the current note's children visible
-- Nc_Tree_Note_Expand(nDocID, strCurNoteID)