-- Notecase Pro sample script (requires Notecase Pro >= 3.5.0)
--
-- Description:
-- Stores the currently loaded documents as a group (so you can load this exact group again)
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 5)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.5.0")
	return
end 

strName = Nc_GUI_InputDlg("Enter Session Name", "", "", 0, 1)

strFileName = Nc_Config_ConfigDir_Get() .. strName .. ".session"
f = io.open(strFileName, "w")
if f == nil then
	Nc_GUI_MessageBox("Failed to open output file, aborting")
	return
end

-- write paths of each open document (one per line)
nDocCount =  Nc_App_GetDocCount()
for i=0,nDocCount-1 do
	nDocID = Nc_Doc_ID_GetByIdx(i)
	strDocPath = Nc_Doc_GetPath(nDocID)
	f:write(strDocPath .. "\n")
end
		
f:close()
