-- Notecase Pro sample script (requires Notecase Pro >= 3.1.4)
-- File Name: 38_RestoreListPane.lua
--
-- Description: Restores the List Pane state from the text file 
-- containing note IDs created by the 37_StoreListPane.lua script
--
-- Requires NoteCase Pro v. >= 3.1.4
-- 
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/ 

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 1) or (nMaj == 3 and nMin == 1 and nRev < 4)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.1.4")
	return
end

-- open file dialog for user to designate file that List Pane note IDs are
-- stored in and store returned value as variable strFileName
strFileName = Nc_GUI_FileDlg(0, "", "Open Stored List State File") 

-- check to see if user canceled file selection and abort the script if no file was selected
if strFileName == "" then
	return 
end

-- open designated file 
f = io.open(strFileName, "r") 

-- add to the Note Pane each note with an ID matching an ID stored in the designated file
for line in f:lines() do 
	Nc_App_List_AddNote(line)
end

-- close stored List Pane state file
f:close() 
