-- Notecase Pro sample script (requires Notecase Pro >= 3.1.4)
--
-- Description:
-- Store the curent content of the List Pane into the text file as a list of note ID numbers
-- 
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/ 

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 1) or (nMaj == 3 and nMin == 1 and nRev < 4)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.1.4")
	return
end

-- get info on the currently active document
nDocID = Nc_Doc_ID_GetCur()
nListPaneCount = Nc_App_List_GetCount()

-- select a name of the old Lua script
filename = Nc_GUI_FileDlg(1, "", "Select a file to save state to") 
if filename == "" then
	return 
end

-- write file contents
f = io.open(filename, "w")

-- for each document note
for i=1,nListPaneCount do 
	-- get info on the note
	strNoteID    = Nc_App_List_Note_GetID(i-1)

	f:write(strNoteID .. "\n")
end

f:close()
