-- Notecase Pro sample script (requires Notecase Pro >= 3.1.4)
--
-- Description:
-- Converts a script's old scriptable NoteCase Pro command names
-- (pre v. 3.1.4) to new command names
-- CAUTION: You should back up your scripts before running this script.
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/ 

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 1) or (nMaj == 3 and nMin == 1 and nRev < 4)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.1.4")
	return
end

-- Store the directory from which this script was launched 
-- as an environmental variable sensitive to the file path 
-- naming convention of the current operating environment.
strLua = os.getenv("LUA_CURRENT_DIR")


-- select the filename of the old Lua script
filename = Nc_GUI_FileDlg(0, strLua, "Open old Lua Script")

-- abort the script if the user canceled the file selection
if filename == "" then
	return 
end

-- read file content
f = io.open(filename, "r") 
local strLuaText = f:read("*all")
f:close() 
	
-- replace old API names into the new ones
strLuaText = string.gsub(strLuaText, "NcApplication_Exit", "Nc_App_Exit")
strLuaText = string.gsub(strLuaText, "NcApplication_GetDebugLog", "Nc_App_GetDebugLog")
strLuaText = string.gsub(strLuaText, "NcApplication_GetOSFamily", "Nc_Config_GetOSFamily")
strLuaText = string.gsub(strLuaText, "NcApplication_GetVersion", "Nc_Config_GetAppVersion")
strLuaText = string.gsub(strLuaText, "NcApplication_ListPaneClear", "Nc_App_List_Clear")
strLuaText = string.gsub(strLuaText, "NcApplication_ListPaneNoteCount", "Nc_App_List_GetCount")
strLuaText = string.gsub(strLuaText, "NcApplication_ListPaneAdd", "Nc_App_List_AddNote")
strLuaText = string.gsub(strLuaText, "NcApplication_ListPaneGetNoteID", "Nc_App_List_Note_GetID")
strLuaText = string.gsub(strLuaText, "NcApplication_ListPaneIsActive", "Nc_App_List_GetState")
strLuaText = string.gsub(strLuaText, "NcApplication_ListPaneShow", "Nc_App_List_Switch")
strLuaText = string.gsub(strLuaText, "NcApplication_SetShowIOTimes", "Nc_Config_ShowIOTimes")
strLuaText = string.gsub(strLuaText, "NcClipboard_GetText", "Nc_Env_Clipboard_Get")
strLuaText = string.gsub(strLuaText, "NcClipboard_SetText", "Nc_Env_Clipboard_Set")
strLuaText = string.gsub(strLuaText, "NcCustomProperty_Append", "Nc_Note_CustProp_Append")
strLuaText = string.gsub(strLuaText, "NcCustomProperty_DeleteByIdx", "Nc_Note_CustProp_DeleteByIdx")
strLuaText = string.gsub(strLuaText, "NcCustomProperty_FindByName", "Nc_Note_CustProp_FindByName")
strLuaText = string.gsub(strLuaText, "NcCustomProperty_GetCount", "Nc_Note_CustProp_GetCount")
strLuaText = string.gsub(strLuaText, "NcCustomProperty_GetNameByIdx", "Nc_Note_CustProp_GetNameByIdx")
strLuaText = string.gsub(strLuaText, "NcCustomProperty_GetValueByIdx", "Nc_Note_CustProp_GetValueByIdx")
strLuaText = string.gsub(strLuaText, "NcDocument_DeleteNote", "Nc_Note_Delete")
strLuaText = string.gsub(strLuaText, "NcDocument_GetCurNoteID", "Nc_Note_ID_GetCur")
strLuaText = string.gsub(strLuaText, "NcDocument_GetFilePath", "Nc_Doc_GetPath")
strLuaText = string.gsub(strLuaText, "NcDocument_GetNoteBreadcrumb", "Nc_Note_Breadcrumb_Get")
strLuaText = string.gsub(strLuaText, "NcDocument_GetNoteChildID", "Nc_Note_Child_GetID")
strLuaText = string.gsub(strLuaText, "NcDocument_GetNoteCount", "Nc_Doc_NoteCount")
strLuaText = string.gsub(strLuaText, "NcDocument_GetNoteChildCount", "Nc_Note_ChildCount")
strLuaText = string.gsub(strLuaText, "NcDocument_GetNoteIcon", "Nc_Note_Icon_GetValues")
strLuaText = string.gsub(strLuaText, "NcDocument_GetNoteID", "Nc_Note_ID_GetByIdx")
strLuaText = string.gsub(strLuaText, "NcDocument_GetNoteParentID", "Nc_Note_Parent_GetID")
strLuaText = string.gsub(strLuaText, "NcDocument_GetNoteSelection", "Nc_Note_SelectionRange_Get")
strLuaText = string.gsub(strLuaText, "NcDocument_GetNoteText", "Nc_Note_Content_Get")
strLuaText = string.gsub(strLuaText, "NcDocument_GetNoteTags", "Nc_Note_Tags_Get")
strLuaText = string.gsub(strLuaText, "NcDocument_GetNoteTitle", "Nc_Note_Title_Get")
strLuaText = string.gsub(strLuaText, "NcDocument_InsertNote", "Nc_Note_Insert")
strLuaText = string.gsub(strLuaText, "NcDocument_IsModified", "Nc_Doc_ModifiedState")
strLuaText = string.gsub(strLuaText, "NcDocument_NoteMoveUp", "Nc_Note_MoveUp")
strLuaText = string.gsub(strLuaText, "NcDocument_NoteMoveRight", "Nc_Note_MoveRight")
strLuaText = string.gsub(strLuaText, "NcDocument_NoteMoveLeft", "Nc_Note_MoveLeft")
strLuaText = string.gsub(strLuaText, "NcDocument_NoteMoveDown", "Nc_Note_MoveDown")
strLuaText = string.gsub(strLuaText, "NcDocument_Redo", "Nc_Doc_Redo")
strLuaText = string.gsub(strLuaText, "NcDocument_Save", "Nc_Doc_Save")
strLuaText = string.gsub(strLuaText, "NcDocument_SetCurNoteID", "Nc_Note_ID_SetCur")
strLuaText = string.gsub(strLuaText, "NcDocument_SetNoteIcon", "Nc_Note_Icon_SetValues")
strLuaText = string.gsub(strLuaText, "NcDocument_SetNoteTags", "Nc_Note_Tags_Set")
strLuaText = string.gsub(strLuaText, "NcDocument_SetNoteText", "Nc_Note_Content_Set")
strLuaText = string.gsub(strLuaText, "NcDocument_Undo", "Nc_Doc_Undo")
strLuaText = string.gsub(strLuaText, "NcDocuments_Close", "Nc_Doc_Close")
strLuaText = string.gsub(strLuaText, "NcDocuments_GetCount", "Nc_App_GetDocCount")
strLuaText = string.gsub(strLuaText, "NcDocuments_GetCurID", "Nc_Doc_ID_GetCur")
strLuaText = string.gsub(strLuaText, "NcDocuments_GetID", "Nc_Doc_ID_GetByIdx")
strLuaText = string.gsub(strLuaText, "NcDocuments_Load", "Nc_Doc_Load")
strLuaText = string.gsub(strLuaText, "NcDocuments_New", "Nc_Doc_New")
strLuaText = string.gsub(strLuaText, "NcDocuments_SetCurID", "Nc_Doc_MakeCur")
strLuaText = string.gsub(strLuaText, "NcFileOpenDlg", "Nc_GUI_FileDlg")
strLuaText = string.gsub(strLuaText, "NcMessageBox", "Nc_GUI_MessageBox")
strLuaText = string.gsub(strLuaText, "NcNode_GetDone", "Nc_Note_Flag_Done_Get")
strLuaText = string.gsub(strLuaText, "NcNode_GetNodesThatLinkToMe", "Nc_NoteGroup_NotesLinkingToMe_Get")
strLuaText = string.gsub(strLuaText, "NcNode_SetDone", "Nc_Note_Flag_Done_Set")
strLuaText = string.gsub(strLuaText, "NcNote_GetLinksCount", "Nc_Note_Links_GetCount")
strLuaText = string.gsub(strLuaText, "NcNote_GetLinkTarget", "Nc_Note_Link_GetTarget")
strLuaText = string.gsub(strLuaText, "NcNote_GetLinkType", "Nc_Note_Link_GetType")
strLuaText = string.gsub(strLuaText, "NcNote_GetMarked", "Nc_Note_Flag_Marked_Get")
strLuaText = string.gsub(strLuaText, "NcNote_SetMarked", "Nc_Note_Flag_Marked_Set")
strLuaText = string.gsub(strLuaText, "NcNote_SetTaskCompletedDate", "Nc_Note_Task_DateCompleted_Set")
strLuaText = string.gsub(strLuaText, "NcNote_SetTaskDueDate", "Nc_Note_Task_DateDue_Set")
strLuaText = string.gsub(strLuaText, "NcNote_SetTaskExpireDate", "Nc_Note_Task_DateExpire_Set")
strLuaText = string.gsub(strLuaText, "NcNote_SetTaskStartDate", "Nc_Note_Task_DateStart_Set")
strLuaText = string.gsub(strLuaText, "NcNote_ShowTaskDialog", "Nc_Note_Task_OpenDlg")
strLuaText = string.gsub(strLuaText, "NcStatusBar_Message", "Nc_GUI_StatusBarMessage")

if not (nil == string.find(strLuaText, "NcDocument_GetNoteFlag") ) then
	Nc_GUI_MessageBox("One or more NcDocument_GetNoteFlag calls detected.\nYou will need to replace these manually with one of these commands:\nNc_Note_Flag_Marked_Get,  Nc_Note_Flag_Done_Get, Nc_Note_Flag_ReadOnly_Get  or Nc_Note_Flag_Template_Get\nFor instructions see Help File > User Interface > Shipping Scripts > 36_ConvertLuaScript.lua.")
end
if not (nil == string.find(strLuaText, "NcDocument_SetNoteFlag") ) then
	Nc_GUI_MessageBox("One or more NcDocument_SetNoteFlag calls detected.\nYou will need to replace these manually with one of these commands:\n Nc_Note_Flag_Marked_Set,  Nc_Note_Flag_Done_Set,  Nc_Note_Flag_ReadOnly_Set  or  Nc_Note_Flag_Template_Set\n For Instructions see Help File > User Interface > Shipping Scripts > 36_ConvertLuaScript.lua.")
end

-- select the output file name
filename = Nc_GUI_FileDlg(0, "", "Save as new Lua Script")
if filename == "" then
		return 
end
-- write file contents
f = io.open(filename, "w")
f:write(strLuaText)
f:close()
