-- Notecase Pro sample script (requires Notecase Pro >= 3.1.4)
--
-- Description:
-- marks the current note and all of its ancestors
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 1) or (nMaj == 3 and nMin == 1 and nRev < 4)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.1.4")
	return
end

-- get IDs for the current document and note and store as variables
nDocID = Nc_Doc_ID_GetCur()
strNoteID = Nc_Note_ID_GetCur(nDocID)

-- comment the following line if you want the script to mark the current note too.
strNoteID = Nc_Note_Parent_GetID(nDocID, strNoteID)

while strNoteID ~= "" do
	Nc_Note_Flag_Marked_Set(nDocID, strNoteID, 1)
	
	-- proceed to parent note
	strNoteID = Nc_Note_Parent_GetID(nDocID, strNoteID)
end