-- Notecase Pro sample script (requires Notecase Pro >= 3.1.4)
--
-- Description:
-- set the same icon ("help" icon in this example) to all marked notes of the current document
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 1) or (nMaj == 3 and nMin == 1 and nRev < 4)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.1.4")
	return
end

-- get IDs for current document and note and store values as variables
nDocID = Nc_Doc_ID_GetCur()
nNoteCount = Nc_Doc_NoteCount(nDocID)

-- for each document note
for i=1,nNoteCount do 
	-- store note index value as variable strNoteID (note indexes start from 0)
	strNoteID    = Nc_Note_ID_GetByIdx(nDocID, i-1)

	-- store note Marked flag state as variable bIsMarked
	bIsMarked = Nc_Note_Flag_Marked_Get(nDocID, strNoteID)
	
	if bIsMarked ~= 0 then
		-- set an icon to the note
		-- Nc_Note_Icon_SetValues(nDocID, strNoteID, 0)
		-- Nc_Note_Icon_SetValues(nDocID, strNoteID, 2, "d:\\notecase.png")
		Nc_Note_Icon_SetValues(nDocID, strNoteID, 1, "help")
	end
end 
