-- Notecase Pro sample script (requires Notecase Pro >= 3.1.3)
--
-- Description:
-- Enables you to edit note's raw HTML content, no script customizations are needed
-- For more convenient HTML note editing (HTML syntax highlighting), use the "hermocom's Document Tools" Plugin.
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 1) or (nMaj == 3 and nMin == 1 and nRev < 3)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.1.3")
	return
end

-- get info on the currently active document/note
nDocID = Nc_Doc_ID_GetCur()
strCurNoteID = Nc_Note_ID_GetCur(nDocID)

if strCurNoteID == "" then
 	Nc_GUI_MessageBox("No note selected, aborting")
	return 
end

-- get note contents as HTML
strNoteHtml = Nc_Note_Content_Get(nDocID, strCurNoteID, 1)

-- display in text editor
nDisplayWidth, nDisplayHeight = Nc_Env_DisplaySize_Get(0)
nDlgWidth = .72 * nDisplayWidth
nDlgHeight = .85 * nDisplayHeight
strNoteHtml = Nc_GUI_InputDlg("Edit HTML", strNoteHtml, "", 0, 0, "You can edit notes contents here\n(you might need to use Ctrl+Enter for new line):\n", 1, nDlgWidth, nDlgHeight, 1)

if string.len(strNoteHtml) > 0 then 
	-- replace note content with the edited content
	Nc_Note_Content_Set(nDocID, strCurNoteID, strNoteHtml, 1)
else	
	Nc_GUI_MessageBox("Editing canceled")
end
