-- Notecase Pro sample script (requires Notecase Pro >= 4.1.4)
--
-- Description:
-- import text files with directory structure
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 4 or (nMaj == 4 and nMin < 1) or (nMaj == 4 and nMin == 1 and nRev < 4)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 4.1.4")
	return
end

-- create new document
nDocID = Nc_Doc_New()

-- start enumerating files and folders
strTopLevel = "C:\\temp\\Test"	-- use "/home/user/test" for Linux

function MatchExtension(strName)
  if string.find(strName,"%.txt$") or string.find(strName,"%.TXT$") then 
    return true
  end
  return false
end

function CountFiles(strCurrentDir)
 local nCount = 0
 for file in lfs.dir(strCurrentDir) do
    if file ~= nil and file ~= "." and file ~= ".." then
	    local strEntry = strCurrentDir..'/'..file
	    local attr, strErr = lfs.attributes (strEntry)
		if attr ~= nil then
		    assert (type(attr) == "table", "invalid attr for file: " .. strEntry)
		    if attr.mode == "directory" then
		      nCount = nCount + CountFiles(strEntry)
		    else
		      if MatchExtension(strEntry) then
		        nCount = nCount + 1
		      end
	    end
	end
    end
 end
 return nCount  
end

function ProcessDir(strCurrentDir, strParentNodeID)

 for file in lfs.dir(strCurrentDir) do
    if file ~= nil and file ~= "." and file ~= ".." then
        local strEntry = strCurrentDir..'/'..file
        local attr, strErr = lfs.attributes (strEntry)
        assert (type(attr) == "table", "invalid attr for file1: " .. strEntry)
        if attr.mode == "directory" then
            -- create note for given folder entry
            -- Nc_GUI_MessageBox("Folder entry:" .. strEntry .. " Parent Note ID:" .. strParentNodeID)
            local strNewNoteID = Nc_Note_Insert(nDocID, strParentNodeID, -1, file)

            -- process subdirectory recursively
            ProcessDir(strEntry, strNewNoteID)
        else
						-- create note for given file entry
            -- Nc_GUI_MessageBox("File entry:" .. file .. " PArent Note ID:" .. strParentNodeID)
            
            -- create note for given file entry
            -- process only .txt files
            if MatchExtension(strEntry) then
              nCurFile = nCurFile + 1
              Nc_GUI_ProgressDlg_SetPos(nCurFile)

              -- Nc_GUI_MessageBox("Text entry:" .. file .. " PArent Note ID:" .. strParentNodeID)
              -- remove .txt suffix
							strTitle = string.sub(file, 1, -5)
              local strNewNoteID = Nc_Note_Insert(nDocID, strParentNodeID, -1, strTitle)

              -- read file contents
              local t, err = Nc_String_LoadFile(strEntry)
              
              -- set as note text
              Nc_Note_Content_Set(nDocID, strNewNoteID, t, 0)
            end

      end
	end
 end

end -- function

-- show import progress
nCurFile = 0
nTotalFiles = CountFiles(strTopLevel)
-- Nc_GUI_MessageBox("Total files:" .. nTotalFiles)
Nc_GUI_ProgressDlg_Start("Importing files", nTotalFiles)

ProcessDir(strTopLevel, "")

Nc_Note_ID_SetCur("")
Nc_GUI_ProgressDlg_Close()
Nc_GUI_MessageBox("Done!")