-- Notecase Pro sample script (requires Notecase Pro >= 3.1.4)
--
-- Description:
-- tag the note using the clipboard text content (must be only one tag per line)
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 1) or (nMaj == 3 and nMin == 1 and nRev < 4)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.1.4")
	return
end

-- break string into the array
function lines(str)
  local t = {}
  local i, lstr = 1, #str
  while i <= lstr do
    local x, y = string.find(str, "\r?\n", i)
    if x then t[#t + 1] = string.sub(str, i, x - 1)
    else break
    end
    i = y + 1
  end
  if i <= lstr then t[#t + 1] = string.sub(str, i) end
  return t
end

-- get info on the currently active document/note
nDocID = Nc_Doc_ID_GetCur()
strCurNoteID = Nc_Note_ID_GetCur(nDocID)

if strCurNoteID == "" then
 	Nc_GUI_MessageBox("No note selected, aborting")
	return 
end

-- get clipboard text
strClipboardText = Nc_Env_Clipboard_Get()

if strClipboardText == "" then
 	Nc_GUI_MessageBox("Clipboard text is empty, aborting")
	return 
end

-- Nc_GUI_MessageBox(strClipboardText)

-- break text lines into the list
local tableLines = lines(strClipboardText)

-- create a new keyword string
strTagString = ";"
nTableSize = # tableLines
for i=1,nTableSize do 
	strTagString = strTagString .. tableLines[i]
	strTagString = strTagString .. ";"
end

-- Nc_GUI_MessageBox(strTagString)

-- preserve the old tags
strOldTags = Nc_Note_Tags_Get(nDocID, strCurNoteID)

strTagString = strOldTags .. strTagString

-- finally set the tags
Nc_Note_Tags_Set(nDocID, strCurNoteID, strTagString)
