	-- Notecase Pro sample script (requires Notecase Pro >= 3.1.4)
--
-- Description:
-- write to clipboard a list of all tags used in the current note
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 1) or (nMaj == 3 and nMin == 1 and nRev < 4)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.1.4")
	return
end

-- break string into the array
function lines(str)
  local t = {}
  local i, lstr = 1, #str
  while i <= lstr do
    local x, y = string.find(str, "\r?\n", i)
    if x then t[#t + 1] = string.sub(str, i, x - 1)
    else break
    end
    i = y + 1
  end
  if i <= lstr then t[#t + 1] = string.sub(str, i) end
  return t
end

-- get info on the currently active document/note
nDocID = Nc_Doc_ID_GetCur()
strCurNoteID = Nc_Note_ID_GetCur(nDocID)

if strCurNoteID == "" then
 	Nc_GUI_MessageBox("No note selected, aborting")
	return 
end  

strText = Nc_Note_Tags_Get(nDocID, strCurNoteID)

-- delete first tag delimiter character
c = string.sub(strText, 1, 1)
if c == ';' then
 strText = string.sub(strText, 2, string.len(strText))
end

-- replace delimiter with new line 
strText = string.gsub(strText, ";", "\n")

-- Nc_GUI_MessageBox(strText)

-- sort the text
local eol = string.match(strText, "\n$")
local buf = lines(strText)
table.sort(buf)
local out = table.concat(buf, "\n")
if eol then out = out.."\n" end

strText = out;

-- write text to clipboard

Nc_Env_Clipboard_Set(strText, 0)
