-- Notecase Pro sample script (requires Notecase Pro >= 2.8.6)
--
-- Description:
-- marks all notes that have "Done" flag set
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 1) or (nMaj == 3 and nMin == 1 and nRev < 4)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.1.4")
	return
end

-- get info on the currently active document
nDocID = Nc_Doc_ID_GetCur()
nNodeCount = Nc_Doc_NoteCount(nDocID)

-- for each document note
for i=1,nNodeCount do 
	-- get info on the note (note indexes start from 0)
	strNodeID    = Nc_Note_ID_GetByIdx(nDocID, i-1)

	-- get note's Done flag state and store as variable bIsDone
	bIsDone = Nc_Note_Flag_Done_Get(nDocID, strNodeID)
	
	-- test if note is flagged done and if not flag as done
	if bIsDone ~= 0 then
		Nc_Note_Flag_Marked_Set(nDocID, strNodeID, 1)
	end
	
end 
 