-- Notecase Pro sample script (requires Notecase Pro >= 3.1.3)
--
-- Description:
-- 	close all currently opened documents
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 1) or (nMaj == 3 and nMin == 1 and nRev < 3)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.1.3")
	return
end

-- get count of currently opened documents
nCount = Nc_App_GetDocCount()

-- close each open document, starting from higher index ones
-- to close a document you must know its ID value (parameter for Nc_Doc_Close method)
for i=nCount-1,0,-1 do
	nDocID = Nc_Doc_ID_GetByIdx(i)
	Nc_Doc_Close(nDocID)
end 
